/*
 * Decompiled with CFR 0.152.
 */
package dioscuri;

import dioscuri.GUI;
import java.io.File;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Constants {
    private static final Logger logger = Logger.getLogger(Constants.class.getName());
    public static final File JAR_OR_FOLDER = Constants.findRoot();
    public static final File EXE_FOLDER = JAR_OR_FOLDER.isFile() ? JAR_OR_FOLDER.getParentFile() : JAR_OR_FOLDER;
    public static final String EMULATOR_NAME = "Dioscuri - modular emulator for digital preservation";
    public static final String EMULATOR_VERSION = "0.7.0";
    public static final String EMULATOR_DATE = "January, 2011";
    public static final String EMULATOR_CREATOR = "Koninklijke Bibliotheek (KB), Nationaal Archief of the Netherlands, Planets, KEEP";
    public static final String CONFIG_DIR = new File(EXE_FOLDER, "config").getAbsolutePath();
    public static final String EMULATOR_ICON_IMAGE = new File(CONFIG_DIR, "dioscuri_icon.gif").getAbsolutePath();
    public static final String EMULATOR_SPLASHSCREEN_IMAGE = new File(CONFIG_DIR, "dioscuri_splashscreen_2010_v043.gif").getAbsolutePath();
    public static final String EMULATOR_LOGGING_PROPERTIES = new File(CONFIG_DIR, "logging.properties").getAbsolutePath();
    public static final String DEFAULT_CONFIG_XML = new File(CONFIG_DIR, "DioscuriConfig.xml").getAbsolutePath();
    public static final String BOCHS_BIOS = new File(EXE_FOLDER, "images/bios/BIOS-bochs-latest").getAbsolutePath();
    public static final String VGA_BIOS = new File(EXE_FOLDER, "images/bios/VGABIOS-lgpl-latest").getAbsolutePath();

    private Constants() {
    }

    private static File findRoot() {
        try {
            return new File(URLDecoder.decode(GUI.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8"));
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "could not find the exe-path of Dioscuri");
            return new File(".");
        }
    }
}

